# Security Policy

We greatly appreciate the time and effort that goes into the investigation of security issues. Thank you for helping to keep our platform safe and secure. The following is important information regarding how to report and handle any suspected vulnerabilities. 

## Reporting a Vulnerability
:exclamation: If you find a security vulnerability, please do not open a GitHub issue or post it publicly. Please email support@gibbonedu.org instead. 

This is in keeping with the best practices for responsible disclosure, and gives our development team time to investigate any suspected vulnerabilities as well as patch them and release a timely update to our community.

We take all reports of vulnerabilities seriously, and will aim to reply to any such report in a timely fashion. Please be aware that, as a piece of school software, our development team may be less available during times of school breaks and holidays. If you do not receive a response to your email within 48 hours please re-send your email to help ensure we have received it.

## Supported Versions

The current stable version of Gibbon is always supported, and will be updated in the case of a security issue. The stable version can be found on the [Gibbon Website](https://gibbonedu.org/download/), as well as the latest release on GitHub. The cutting edge version, which can be found as the default branch [here on GitHub](https://github.com/GibbonEdu/core), is supported and will be patched, however please be aware that this version often contains changes and experimental features. Schools are advised to use the stable version in production and to keep their systems up-to-date with the latest stable version. 

Older versions of Gibbon are not directly supported. In the event of a security update we advise schools to update to the latest stable version. If this, however, is not possible, we're happy to help advise users about how to apply security fixes to their current version.

## Release Cycle
Gibbon runs on a 6 month release cycle, with stable versions available every January 20th and June 20th. If any security vulnerability is of high severity we will issue a mid-version patch, which will be released through GitHub and publicized through our mailing list. Gibbon also includes a version detection tool in the System Admin overview and will display a notification to administrators if an update is available.

## CVE Databases
We ask that developers do no not immediately post security vulnerabilities in a CVE database. Many schools who use Gibbon may have limited funds or IT infrastructure and may only update once or twice a year. It's important to give our community ample time to update their systems before a vulnerability is posted on a public database. Once an issue has been patched and released to the community, we are open to posting these after a window of 3 months, to help ensure all systems are updated. We want to be sure to consider our schools and their capacity, to ensure we're putting their interests first.

## Bug Bounties
Gibbon is free, open-source and non-profit, and as such, we do not offer paid bug bounties. We greatly appreicate the work of external security researchers, and are happy to give credit to them in our release notes, but as a non-profit project we do not offer monetary compensation for bug reports.
